function test_suite = testCellstr %#ok<*STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
p = polysym.empty;
assertTrue(isempty(cellstr(p)))

function testDefault
p = polysym;
assertEqual(cellstr(p),{'0'})

function testRandNumeric
r = rand;
p = polysym(r);
precision = floor(log10(r/eps(r)));
assertEqual(cellstr(p),{num2str(r,precision)})

function testCos
p = polysym('x');
q = cos(p);
assertEqual(cellstr(q),{'cos(x)'})

% "returns ... a cell array of strings with the same dimensions as OBJ."
function testArray
r = randi(100,3);
p = polysym(r);
assertEqual(cellstr(p),cellfun(@num2str,num2cell(r),'UniformOutput',false))

% "Any objects that are equivalent to zero are represented by the string
% '0'."
function testZeroChar
p = polysym('0');
assertEqual(cellstr(p),{'0'})

function testZeroNumeric
p = polysym(0);
assertEqual(cellstr(p),{'0'})

function testZeroCell
p = polysym({'0'});
assertEqual(cellstr(p),{'0'})
